"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const typeorm_2 = require("typeorm");
const login_history_entity_1 = require("./entities/login-history.entity");
let LoginHistoryService = class LoginHistoryService {
    constructor(repo) {
        this.repo = repo;
    }
    async findAll(limit, offset, accountId) {
        const [result, total] = await this.repo.findAndCount({
            where: { accountId },
            take: limit,
            skip: offset,
            order: { createdAt: 'DESC' },
        });
        return { result, total };
    }
    async activateLogin(id) {
        try {
            return this.repo
                .createQueryBuilder()
                .update()
                .set({
                status: enum_1.DefaultStatus.DEACTIVE,
            })
                .where('accountId = :accountId', { accountId: id })
                .execute();
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Try after some time!');
        }
    }
};
LoginHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(login_history_entity_1.LoginHistory)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], LoginHistoryService);
exports.LoginHistoryService = LoginHistoryService;
//# sourceMappingURL=login-history.service.js.map