"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const account_entity_1 = require("../account/entities/account.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const outlet_detail_entity_1 = require("../outlet-details/entities/outlet-detail.entity");
let DashboardService = class DashboardService {
    constructor(aRepo, oRepo, odRepo) {
        this.aRepo = aRepo;
        this.oRepo = oRepo;
        this.odRepo = odRepo;
    }
    async suboutletCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'SUB OUTLET',
        });
        return await query.getRawMany();
    }
    async deliveryboyCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'Delivery Boy',
        });
        return await query.getRawMany();
    }
    async adminCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'ADMIN',
        });
        return await query.getRawMany();
    }
    async superadminCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'SUPER ADMIN',
        });
        return await query.getRawMany();
    }
    async staffCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'STAFF',
        });
        return await query.getRawMany();
    }
    async basekitchenCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .addSelect(['account.roles as name'])
            .where('account.roles = :roles', {
            roles: 'BASE KITCHEN',
        });
        return await query.getRawMany();
    }
    async cartCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'CART',
        });
        return await query.getRawMany();
    }
    async draftCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'DRAFT',
        });
        return await query.getRawMany();
    }
    async orderdCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'ORDERED',
        });
        return await query.getRawMany();
    }
    async dispatchedCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'DISPATCHED',
        });
        return await query.getRawMany();
    }
    async deliveredCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'DELIVERED',
        });
        return await query.getRawMany();
    }
    async returnedCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'RETURNED',
        });
        return await query.getRawMany();
    }
    async partialCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status = :status', {
            status: 'PARTIALLY DELIVERED',
        });
        return await query.getRawMany();
    }
    async totalStaffsCounts() {
        const query = this.aRepo
            .createQueryBuilder('account')
            .select(['COUNT(account.id) AS count'])
            .where('account.roles = :roles OR account.roles = :sroles', {
            roles: 'ADMIN',
            sroles: 'STAFF',
        });
        return await query.getRawMany();
    }
    async totalOrdersCounts() {
        const query = this.oRepo
            .createQueryBuilder('Order')
            .select(['COUNT(Order.id) AS count'])
            .addSelect(['Order.status as name'])
            .where('Order.status != :status OR Order.status != :cstatus', {
            status: 'CART',
            cstatus: 'DRAFT',
        });
        return await query.getRawMany();
    }
    async totalOutletsCounts() {
        const query = this.odRepo
            .createQueryBuilder('outletDetail')
            .select(['COUNT(outletDetail.id) AS count']);
        return await query.getRawMany();
    }
};
DashboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(account_entity_1.Account)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(2, (0, typeorm_1.InjectRepository)(outlet_detail_entity_1.OutletDetail)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], DashboardService);
exports.DashboardService = DashboardService;
//# sourceMappingURL=dashboard.service.js.map