"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactUsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const contact_us_entity_1 = require("./entities/contact-us.entity");
let ContactUsService = class ContactUsService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        try {
            const obj = Object.create(dto);
            return this.repo.save(obj);
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Something bad happened. Please try after some time!');
        }
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('customerQna')
            .select([
            'customerQna.qnaId',
            'customerQna.answer',
            'customerQna.email',
            'customerQna.body',
            'customerQna.phone',
            'customerQna.status',
            'customerQna.subject',
            'customerQna.createdAt',
            'customerQna.updatedAt',
        ])
            .where('ContactUs.status = :status', { status: dto.status })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('contactUs.email LIKE :email OR contactUs.subject LIKE :subject OR contactUs.phone LIKE :phone OR contactUs.body LIKE :body OR contactUs.answer LIKE :answer', {
                email: '%' + keyword + '%',
                subject: '%' + keyword + '%',
                phone: '%' + keyword + '%',
                body: '%' + keyword + '%',
                answer: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'contactUs.createdAt': 'DESC' })
            .offset(dto.offset)
            .skip(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async findOne(contactUsId) {
        const result = await this.repo.findOne({ where: { contactUsId } });
        if (!result) {
            throw new common_1.NotFoundException('Item not found!');
        }
        return result;
    }
    async update(contactUsId, dto, accountId) {
        const result = await this.repo.findOne({ where: { contactUsId } });
        if (result) {
            throw new common_1.NotFoundException('Item not Found!');
        }
        try {
            const obj = Object.assign(result, { answer: dto.answer, accountId });
            return this.repo.save(obj);
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Something bad happened. Please try after some time!');
        }
    }
};
ContactUsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(contact_us_entity_1.ContactUs)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ContactUsService);
exports.ContactUsService = ContactUsService;
//# sourceMappingURL=contact-us.service.js.map