import { Repository } from 'typeorm';
import { BusinessDetailDto, CompanyDetailDto, PaginationDto, PaginationSDto, StatusDto } from './dto/company-detail.dto';
import { CompanyDetail } from './entities/company-detail.entity';
export declare class CompanyDetailsService {
    private readonly repo;
    constructor(repo: Repository<CompanyDetail>);
    create(dto: BusinessDetailDto): Promise<any>;
    findAll(dto: PaginationSDto): Promise<{
        result: CompanyDetail[];
        total: number;
    }>;
    findList(dto: PaginationDto): Promise<{
        result: CompanyDetail[];
        total: number;
    }>;
    findCompany(id: string): Promise<CompanyDetail>;
    findOne(id: string): Promise<CompanyDetail>;
    info(id: string): Promise<CompanyDetail>;
    update(id: string, dto: CompanyDetailDto): Promise<CompanyDetail & CompanyDetailDto>;
    file(id: string, image: string): Promise<CompanyDetail & {
        file: string;
        filePath: string;
    }>;
    logo(id: string, image: string): Promise<CompanyDetail & {
        logo: string;
        logoPath: string;
    }>;
    status(id: string, dto: StatusDto): Promise<CompanyDetail & StatusDto>;
}
