import { PaginationDto } from 'src/common/dto/pagination.dto';
import { CategoryService } from './category.service';
import { CategoryDto, PaginationSDto, StatusDto } from './dto/category.dto';
export declare class CategoryController {
    private readonly categoryService;
    constructor(categoryService: CategoryService);
    create(dto: CategoryDto): Promise<any>;
    findAll(query: PaginationSDto): Promise<{
        result: import("./entities/category.entity").Category[];
        total: number;
    }>;
    find(query: PaginationDto): Promise<{
        result: import("./entities/category.entity").Category[];
        total: number;
    }>;
    findOne(id: string): Promise<import("./entities/category.entity").Category>;
    update(id: string, dto: CategoryDto): Promise<import("./entities/category.entity").Category & {
        name: string;
    }>;
    status(id: string, dto: StatusDto): Promise<import("./entities/category.entity").Category & import("../common/dto/bool-status.dto").BoolStatusDto>;
}
