"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const cache_manager_1 = require("@nestjs/cache-manager");
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const throttler_1 = require("@nestjs/throttler");
const typeorm_1 = require("@nestjs/typeorm");
const account_module_1 = require("./account/account.module");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const area_module_1 = require("./area/area.module");
const auth_module_1 = require("./auth/auth.module");
const category_module_1 = require("./category/category.module");
const city_module_1 = require("./city/city.module");
const company_category_module_1 = require("./company-category/company-category.module");
const company_details_module_1 = require("./company-details/company-details.module");
const company_sub_category_module_1 = require("./company-sub-category/company-sub-category.module");
const contact_us_module_1 = require("./contact-us/contact-us.module");
const dashboard_module_1 = require("./dashboard/dashboard.module");
const faqs_module_1 = require("./faqs/faqs.module");
const feedback_module_1 = require("./feedback/feedback.module");
const login_history_module_1 = require("./login-history/login-history.module");
const menus_module_1 = require("./menus/menus.module");
const notifications_module_1 = require("./notifications/notifications.module");
const notify_module_1 = require("./notify/notify.module");
const orders_module_1 = require("./orders/orders.module");
const outlet_branch_module_1 = require("./outlet-branch/outlet-branch.module");
const outlet_details_module_1 = require("./outlet-details/outlet-details.module");
const permissions_module_1 = require("./permissions/permissions.module");
const settings_module_1 = require("./settings/settings.module");
const staff_details_module_1 = require("./staff-details/staff-details.module");
const state_module_1 = require("./state/state.module");
const sub_category_module_1 = require("./sub-category/sub-category.module");
const tickets_module_1 = require("./tickets/tickets.module");
const user_permissions_module_1 = require("./user-permissions/user-permissions.module");
const outlet_category_module_1 = require("./outlet-category/outlet-category.module");
const outlet_sub_category_module_1 = require("./outlet-sub-category/outlet-sub-category.module");
const route_master_module_1 = require("./route-master/route-master.module");
const route_assgin_log_module_1 = require("./route-assgin-log/route-assgin-log.module");
let AppModule = class AppModule {
};
AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot(),
            throttler_1.ThrottlerModule.forRoot([
                {
                    name: 'short',
                    ttl: 1000,
                    limit: 3,
                },
                {
                    name: 'medium',
                    ttl: 10000,
                    limit: 20,
                },
                {
                    name: 'long',
                    ttl: 60000,
                    limit: 100,
                },
            ]),
            typeorm_1.TypeOrmModule.forRoot({
                type: 'mysql',
                host: process.env.SM_DB_HOST,
                port: Number(process.env.SM_DB_PORT),
                username: process.env.SM_USER_NAME,
                password: process.env.SM_DB_PASS,
                database: process.env.SM_DB_NAME,
                entities: [__dirname + '/**/*.entity{.ts,.js}'],
                synchronize: false,
                logging: false,
            }),
            cache_manager_1.CacheModule.register({
                isGlobal: true,
            }),
            account_module_1.AccountModule,
            auth_module_1.AuthModule,
            login_history_module_1.LoginHistoryModule,
            staff_details_module_1.StaffDetailsModule,
            menus_module_1.MenusModule,
            permissions_module_1.PermissionsModule,
            user_permissions_module_1.UserPermissionsModule,
            category_module_1.CategoryModule,
            sub_category_module_1.SubCategoryModule,
            outlet_details_module_1.OutletDetailsModule,
            outlet_branch_module_1.OutletBranchModule,
            state_module_1.StateModule,
            area_module_1.AreaModule,
            city_module_1.CityModule,
            notifications_module_1.NotificationsModule,
            orders_module_1.OrdersModule,
            tickets_module_1.TicketsModule,
            contact_us_module_1.ContactUsModule,
            settings_module_1.SettingsModule,
            feedback_module_1.FeedbackModule,
            faqs_module_1.FaqsModule,
            company_details_module_1.CompanyDetailsModule,
            company_category_module_1.CompanyCategoryModule,
            company_sub_category_module_1.CompanySubCategoryModule,
            dashboard_module_1.DashboardModule,
            notify_module_1.NotifyModule,
            outlet_category_module_1.OutletCategoryModule,
            outlet_sub_category_module_1.OutletSubCategoryModule,
            route_master_module_1.RouteMasterModule,
            route_assgin_log_module_1.RouteAssginLogModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);
exports.AppModule = AppModule;
//# sourceMappingURL=app.module.js.map