"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const bcrypt = require("bcrypt");
const enum_1 = require("../enum");
const staff_detail_entity_1 = require("../staff-details/entities/staff-detail.entity");
const typeorm_2 = require("typeorm");
const account_entity_1 = require("./entities/account.entity");
let AccountService = class AccountService {
    constructor(repo, staffRepo) {
        this.repo = repo;
        this.staffRepo = staffRepo;
    }
    async create(dto, createdBy) {
        const user = await this.repo.findOne({
            where: { loginId: dto.loginId, roles: dto.roles },
        });
        if (user) {
            throw new common_1.ConflictException('Login id already exists!');
        }
        const encryptedPassword = await bcrypt.hash(dto.password, 13);
        const obj = Object.create({
            loginId: dto.loginId,
            password: encryptedPassword,
            createdBy,
            roles: dto.roles,
            employeeId: dto.employeeId,
            passwordShow: dto.password,
        });
        const payload = await this.repo.save(obj);
        const object = Object.create({
            name: dto.name,
            emailId: dto.emailId,
            gender: dto.gender,
            dob: dto.dob,
            accountId: payload.id,
            phone: dto.phone,
        });
        if (dto.roles === enum_1.UserRole.STAFF ||
            dto.roles === enum_1.UserRole.ADMIN ||
            dto.roles === enum_1.UserRole.SUPER_ADMIN ||
            dto.roles === enum_1.UserRole.DELIVERY_BOY) {
            this.staffRepo.save(object);
        }
        return payload;
    }
    async outletDetail(loginId, password, createdBy) {
        const user = await this.repo.findOne({
            where: { loginId: loginId, roles: enum_1.UserRole.SUB_OUTLET },
        });
        if (user) {
            throw new common_1.ConflictException('Login id already exists!');
        }
        const encryptedPassword = await bcrypt.hash(password, 13);
        const obj = Object.create({
            loginId: loginId,
            password: encryptedPassword,
            passwordShow: password,
            createdBy,
            roles: enum_1.UserRole.SUB_OUTLET,
        });
        return this.repo.save(obj);
    }
    async find(dto, createdBy) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .where('account.status = :status AND account.roles = :roles AND account.createdBy = :createdBy', {
            status: dto.status,
            roles: dto.role,
            createdBy: createdBy,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('account.loginId LIKE :loginId OR staffDetail.name LIKE :pname', {
                loginId: '%' + keyword + '%',
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'staffDetail.name': 'ASC' })
            .skip(dto.offset)
            .take(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('account')
            .leftJoinAndSelect('account.companyDetail', 'companyDetail')
            .where('account.status = :status AND account.roles = :roles', {
            status: dto.status,
            roles: dto.role,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('account.phoneNumber LIKE :phoneNumber OR companyDetail.name LIKE :dname', {
                phoneNumber: '%' + keyword + '%',
                dname: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'companyDetail.name': 'ASC' })
            .skip(dto.offset)
            .take(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async outletProfile(id) {
        const result = await this.repo
            .createQueryBuilder('account')
            .leftJoinAndSelect('account.outletDetail', 'outletDetail')
            .leftJoinAndSelect('outletDetail.city', 'city')
            .leftJoinAndSelect('outletDetail.state', 'state')
            .leftJoinAndSelect('outletDetail.area', 'area')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletBranch.city', 'ocity')
            .leftJoinAndSelect('outletBranch.state', 'ostate')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .select([
            'account.id',
            'outletDetail.id',
            'outletDetail.outletId',
            'outletDetail.storeName',
            'outletDetail.contactPerson',
            'outletDetail.address',
            'outletDetail.latitude',
            'outletDetail.longitude',
            'outletDetail.storeOpenTime',
            'outletDetail.orderOpenTime',
            'outletDetail.orderCloseTime',
            'outletDetail.type',
            'outletDetail.status',
            'outletBranch.id',
            'outletBranch.branchName',
            'outletBranch.contactPersonName',
            'outletBranch.email',
            'outletBranch.phone',
            'outletBranch.logo',
            'outletBranch.status',
            'companyDetail.id',
            'companyDetail.businessName',
            'companyDetail.logo',
            'companyDetail.email',
            'companyDetail.desc',
            'companyDetail.address',
            'companyDetail.status',
            'area.id',
            'area.name',
            'city.id',
            'city.name',
            'state.id',
            'state.name',
        ])
            .where('account.id = :id AND account.roles = :roles', {
            id: id,
            roles: enum_1.UserRole.SUB_OUTLET,
        })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Profile not found!');
        }
        return result;
    }
    async deliveryProfile(id) {
        const result = await this.repo
            .createQueryBuilder('account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .select([
            'account.id',
            'account.employeeId',
            'staffDetail.id',
            'staffDetail.name',
            'staffDetail.phone',
            'staffDetail.designation',
            'staffDetail.panNo',
            'staffDetail.aadharNo',
            'staffDetail.profile',
            'staffDetail.pan',
            'staffDetail.aadhar',
            'staffDetail.gender',
            'staffDetail.dob',
        ])
            .where('account.id = :id AND account.roles = :roles', {
            id: id,
            roles: enum_1.UserRole.DELIVERY_BOY,
        })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Profile not found!');
        }
        return result;
    }
    async findOne(id) {
        const user = await this.repo.findOne({
            relations: ['staffDetail'],
            where: { id },
        });
        if (!user) {
            throw new common_1.ConflictException('User not found!');
        }
        return user;
    }
    async updateOwnPassword(dto, id) {
        const user = await this.repo.findOne({ where: { id } });
        if (!user) {
            throw new common_1.ConflictException('User detail not found!');
        }
        const comparePassword = await bcrypt.compare(dto.oldPassword, user.password);
        if (!comparePassword) {
            throw new common_1.NotAcceptableException('Incorrect old password!');
        }
        const epassword = await bcrypt.hash(dto.password, 13);
        const obj = Object.assign(user, {
            password: epassword,
            passwordShow: dto.password,
        });
        return this.repo.save(obj);
    }
    async updatePassword(dto, id) {
        const user = await this.repo.findOne({ where: { id } });
        if (!user) {
            throw new common_1.ConflictException('User detail not found!');
        }
        const epassword = await bcrypt.hash(dto.password, 13);
        const obj = Object.assign(user, {
            password: epassword,
            passwordShow: dto.password,
        });
        return this.repo.save(obj);
    }
    async status(id, status) {
        const user = await this.repo.findOne({ where: { id } });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        const obj = Object.assign(user, status);
        return this.repo.save(obj);
    }
    async remove(id) {
        const user = await this.repo.findOne({ where: { id } });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        const obj = Object.assign(user, { status: enum_1.DefaultStatus.DELETED });
        return this.repo.save(user);
    }
};
AccountService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(account_entity_1.Account)),
    __param(1, (0, typeorm_1.InjectRepository)(staff_detail_entity_1.StaffDetail)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], AccountService);
exports.AccountService = AccountService;
//# sourceMappingURL=account.service.js.map