import { StaffDetail } from 'src/staff-details/entities/staff-detail.entity';
import { Repository } from 'typeorm';
import { CreateAccountDto, PaginationDto, StatusDto, PasswordDto, PasswordWithOldDto } from './dto/account.dto';
import { Account } from './entities/account.entity';
export declare class AccountService {
    private readonly repo;
    private readonly staffRepo;
    constructor(repo: Repository<Account>, staffRepo: Repository<StaffDetail>);
    create(dto: CreateAccountDto, createdBy: string): Promise<any>;
    outletDetail(loginId: string, password: string, createdBy: string): Promise<any>;
    find(dto: PaginationDto, createdBy: string): Promise<{
        result: Account[];
        total: number;
    }>;
    findAll(dto: PaginationDto): Promise<{
        result: Account[];
        total: number;
    }>;
    outletProfile(id: string): Promise<Account>;
    deliveryProfile(id: string): Promise<Account>;
    findOne(id: string): Promise<Account>;
    updateOwnPassword(dto: PasswordWithOldDto, id: string): Promise<Account & {
        password: any;
        passwordShow: string;
    }>;
    updatePassword(dto: PasswordDto, id: string): Promise<Account & {
        password: any;
        passwordShow: string;
    }>;
    status(id: string, status: StatusDto): Promise<Account & StatusDto>;
    remove(id: string): Promise<Account>;
}
