"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const permissions_decorator_1 = require("../auth/decorators/permissions.decorator");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
const enum_1 = require("../enum");
const menus_service_1 = require("../menus/menus.service");
const permissions_service_1 = require("../permissions/permissions.service");
const user_permissions_service_1 = require("../user-permissions/user-permissions.service");
const account_service_1 = require("./account.service");
const account_dto_1 = require("./dto/account.dto");
const account_entity_1 = require("./entities/account.entity");
let AccountController = class AccountController {
    constructor(accountService, menuService, permissionService, userPermService) {
        this.accountService = accountService;
        this.menuService = menuService;
        this.permissionService = permissionService;
        this.userPermService = userPermService;
    }
    async create(dto, user) {
        dto.settingId = user.settingId;
        const account = await this.accountService.create(dto, user.id);
        const menus = await this.menuService.findAll();
        const perms = await this.permissionService.findAll();
        const obj = [];
        menus.forEach((menu) => {
            perms.forEach((perm) => {
                obj.push({
                    accountId: account.id,
                    menuId: menu.id,
                    permissionId: perm.id,
                });
            });
        });
        this.userPermService.create(obj);
        return account;
    }
    find(query, user) {
        return this.accountService.find(query, user.id);
    }
    findById(query, id) {
        return this.accountService.find(query, id);
    }
    outletProfile(user) {
        return this.accountService.outletProfile(user.id);
    }
    profile(user) {
        return this.accountService.deliveryProfile(user.id);
    }
    findAll(query) {
        return this.accountService.findAll(query);
    }
    findOne(id) {
        return this.accountService.findOne(id);
    }
    updateOwnPassword(dto, user) {
        return this.accountService.updateOwnPassword(dto, user.id);
    }
    updatePassword(dto, id) {
        return this.accountService.updatePassword(dto, id);
    }
    status(id, dto) {
        dto.wrongCount = 0;
        return this.accountService.status(id, dto);
    }
    remove(id) {
        return this.accountService.remove(id);
    }
};
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.CREATE, 'account']),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.CreateAccountDto, account_entity_1.Account]),
    __metadata("design:returntype", Promise)
], AccountController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('my-staff'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'account']),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.PaginationDto, account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "find", null);
__decorate([
    (0, common_1.Get)('my-staff/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'account']),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.PaginationDto, String]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "findById", null);
__decorate([
    (0, common_1.Get)('outlet/profile'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.SUB_OUTLET),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "outletProfile", null);
__decorate([
    (0, common_1.Get)('outlet/delivery-boy/profile'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.DELIVERY_BOY),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "profile", null);
__decorate([
    (0, common_1.Get)('vendors'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'account']),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'account']),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('password'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'account']),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.PasswordWithOldDto,
        account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "updateOwnPassword", null);
__decorate([
    (0, common_1.Patch)('password/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [account_dto_1.PasswordDto, String]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "updatePassword", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'account']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, account_dto_1.StatusDto]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "status", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.DELETE, 'account']),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AccountController.prototype, "remove", null);
AccountController = __decorate([
    (0, common_1.Controller)('account'),
    __metadata("design:paramtypes", [account_service_1.AccountService,
        menus_service_1.MenusService,
        permissions_service_1.PermissionsService,
        user_permissions_service_1.UserPermissionsService])
], AccountController);
exports.AccountController = AccountController;
//# sourceMappingURL=account.controller.js.map