import axios from 'axios';

export async function sendNotifications(
  fcm: string,
  title: string,
  msg: string,
) {
  try {
    const payload = await axios.post(
      'https://fcm.googleapis.com/fcm/send',
      {
        to: fcm,
        data: {
          body: msg,
          title: title,
          sound: 'default',
          type: 1,
          priority: "high"
        },
        notification: {
          body: msg,
          title: title,
          sound: 'default',
          type: 1,
          priority: "high"
        },
      },
      {
        headers: {
          'Content-Type': 'application/json',
          'Authorization': 'key=' + process.env.NOTIFY_AUTH,
        },
      },
    );
    return payload.data;
  } catch (error) {
    return { Stauts: 'Error', Details: null };
  }
}

export async function sendBulkNotifications(title: string, msg: string) {
  try {
    const payload = await axios.post(
      'https://fcm.googleapis.com/fcm/send',
      {
        to: '/topics/all',
        data: {
          body: msg,
          title: title,
          sound: 'default',
          type: 1,
        },
        notification: {
          body: msg,
          title: title,
          sound: 'default',
          type: 1,
        },
      },
      {
        headers: {
          'cache-control': 'no-cache',
          'Content-Type': 'application/json',
          Authorization: 'key=' + process.env.NOTIFY_AUTH,
        },
      },
    );
    return payload.data;
  } catch (error) {
    return { Stauts: 'Error', Details: null };
  }
}
