import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class RouteAssginLog {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  fromRoute: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  toRoute: string;

  @Column({ type: 'uuid' })
  outletDetailId: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => OutletDetail, (outletDetail) => outletDetail.order, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  outletDetail: OutletDetail[];
}
