import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { OutletSubCategoryDto, BoolStatusDto } from './dto/outlet-sub-category.dto';
import { OutletSubCategory } from './entities/outlet-sub-category.entity';

@Injectable()
export class OutletSubCategoryService {
  constructor(
    @InjectRepository(OutletSubCategory)
    private readonly repo: Repository<OutletSubCategory>,
  ) {}

  async create(dto: OutletSubCategoryDto) {
    JSON.parse(dto.subCategoryId).forEach(async element => {
      const result = await this.repo.findOne({
        where: {
          outletBranchId: dto.outletBranchId,
          subCategoryId: element.id,
        },
      });
      let createDate = {subCategoryId: element.id, outletBranchId: dto.outletBranchId};
      if (result) {
        throw new ConflictException('Already exists!');
      }
      const obj = Object.create(createDate);
      this.repo.save(obj);
    });
    return true;
  }

  async findAll(outletBranchId: string) {
    const result = await this.repo
      .createQueryBuilder('OutletSubCategory')
      .leftJoinAndSelect('OutletSubCategory.subCategory', 'subCategory')
      .where('OutletSubCategory.outletBranchId = :outletBranchId', {
        outletBranchId: outletBranchId,
      })
      .getMany();
    return { result };
  }

  async status(id: string, dto: BoolStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
