import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsNotEmpty, IsOptional, IsUUID, IsBoolean } from 'class-validator';

export class OutletSubCategoryDto {
  @ApiProperty()
  @IsNotEmpty()
  subCategoryId: string;

  @IsOptional()
  @IsUUID()
  outletBranchId: string;
}

export class BoolStatusDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Boolean)
  @IsBoolean()
  status: boolean;
}
