import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AccountModule } from 'src/account/account.module';
import { AuthModule } from 'src/auth/auth.module';
import { NotificationsModule } from 'src/notifications/notifications.module';
import { RouteAssginLog } from 'src/route-assgin-log/entities/route-assgin-log.entity';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { OutletDetail } from './entities/outlet-detail.entity';
import { OutletDetailsController } from './outlet-details.controller';
import { OutletDetailsService } from './outlet-details.service';
import { NotifyModule } from 'src/notify/notify.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([OutletDetail, OutletBranch, RouteAssginLog]),
    AuthModule,
    AccountModule,
    NotifyModule,
  ],
  controllers: [OutletDetailsController],
  providers: [OutletDetailsService],
  exports: [OutletDetailsService],
})
export class OutletDetailsModule {}
