import { Account } from 'src/account/entities/account.entity';
import { Area } from 'src/area/entities/area.entity';
import { City } from 'src/city/entities/city.entity';
import { CompanyStatus, OutletType } from 'src/enum';
import { Order } from 'src/orders/entities/order.entity';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { State } from 'src/state/entities/state.entity';
import { RouteMaster } from 'src/route-master/entities/route-master.entity';
import { RouteAssginLog } from 'src/route-assgin-log/entities/route-assgin-log.entity';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';

@Entity()
export class OutletDetail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  outletId: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  storeName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactPerson: string;

  @Column({ type: 'varchar', length: 20, nullable: true })
  contact: string;

  @Column({ type: 'varchar', length: 250, nullable: true })
  address: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  latitude: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  longitude: string;

  @Column({ type: 'time', nullable: true })
  storeOpenTime: Date;

  @Column({ type: 'time', nullable: true })
  orderOpenTime: Date;

  @Column({ type: 'time', nullable: true })
  orderCloseTime: Date;

  @Column({ type: 'enum', enum: CompanyStatus, default: CompanyStatus.PENDING })
  status: CompanyStatus;

  @Column({ type: 'enum', enum: OutletType, default: OutletType.IN_LOCATION })
  type: OutletType;

  @Column({ type: 'uuid' })
  outletBranchId: string;

  @Column({ type: 'uuid' })
  accountId: string;

  @Column({ type: 'int' })
  areaId: number;

  @Column({ type: 'int' })
  cityId: number;

  @Column({ type: 'int' })
  stateId: number;

  @Column({ type: 'int', nullable: true })
  routeMasterId: number;

  @ManyToOne(() => OutletBranch, (outletBranch) => outletBranch.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  outletBranch: OutletBranch[];

  @ManyToOne(() => Account, (account) => account.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => State, (state) => state.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  state: State[];

  @ManyToOne(() => City, (city) => city.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  city: City[];

  @ManyToOne(() => Area, (area) => area.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  area: Area[];

  @ManyToOne(() => RouteMaster, (routeMaster) => routeMaster.outletDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  routeMaster: RouteMaster[];

  @OneToMany(() => Order, (order) => order.outletDetail)
  order: Order[];

  @OneToMany(() => RouteAssginLog, (routeAssginLog) => routeAssginLog.outletDetail)
  routeAssginLog: RouteAssginLog[];
}
