import { City } from 'src/city/entities/city.entity';
import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { CompanyStatus } from 'src/enum';
import { OutletCategory } from 'src/outlet-category/entities/outlet-category.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { OutletSubCategory } from 'src/outlet-sub-category/entities/outlet-sub-category.entity';
import { State } from 'src/state/entities/state.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class OutletBranch {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  branchName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactPersonName: string;

  @Column({ type: 'varchar', length: 20, nullable: true })
  phone: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  email: string;

  @Column({ type: 'text', nullable: true })
  logo: string;

  @Column({ type: 'text', nullable: true })
  logoName: string;

  @Column({ type: 'enum', enum: CompanyStatus, default: CompanyStatus.PENDING })
  status: CompanyStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'uuid' })
  companyDetailId: string;

  @Column({ type: 'int' })
  cityId: number;

  @Column({ type: 'int' })
  stateId: number;

  @ManyToOne(
    () => CompanyDetail,
    (companyDetail) => companyDetail.outletBranch,
    {
      cascade: true,
      onUpdate: 'CASCADE',
      onDelete: 'CASCADE',
    },
  )
  companyDetail: CompanyDetail[];

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.outletBranch)
  outletDetail: OutletDetail;

  @OneToMany(
    () => OutletCategory,
    (outletCategory) => outletCategory.outletBranch,
  )
  outletCategory: OutletCategory;

  @OneToMany(
    () => OutletSubCategory,
    (outletSubCategory) => outletSubCategory.outletBranch,
  )
  outletSubCategory: OutletSubCategory;

  @ManyToOne(() => State, (state) => state.outletBranch, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  state: State[];

  @ManyToOne(() => City, (city) => city.outletBranch, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  city: City[];
}
