import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';

import { MulterModule } from '@nestjs/platform-express';
import { AuthModule } from 'src/auth/auth.module';
import { OutletDetailsModule } from 'src/outlet-details/outlet-details.module';
import { Order } from './entities/order.entity';
import { OrdersController } from './orders.controller';
import { OrdersService } from './orders.service';
import { diskStorage } from 'multer';
import { NotifyModule } from 'src/notify/notify.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Order]),
    AuthModule,
    OutletDetailsModule,
    NotifyModule,
    // MulterModule.register({ dest: './uploads/orders' }),
    MulterModule.register({
      storage: diskStorage({
        destination: './uploads/orders', // specify the upload directory
        filename: (req, file, cb) => {
          // generate a unique filename here if needed
          const uniqueSuffix =
            Date.now() + '-' + Math.round(Math.random() * 1e9);
          cb(null, `${uniqueSuffix}-${file.originalname}`);
        },
      }),
    }),
  ],
  controllers: [OrdersController],
  providers: [OrdersService],
})
export class OrdersModule {}
