import { Account } from 'src/account/entities/account.entity';
import { OrderStatus } from 'src/enum';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { SubCategory } from 'src/sub-category/entities/sub-category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Order {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'date', nullable: true })
  date: Date;

  @Column({ type: 'int', default: 0 })
  quantity: number;

  @Column({ type: 'int', default: 0 })
  delivered: number;

  @Column({ type: 'int', default: 0 })
  returned: number;

  @Column({ type: 'varchar', length: 100, nullable: true })
  cartId: string;

  @Column({ type: 'text', nullable: true })
  reason: string;

  @Column({ type: 'text', nullable: true })
  signature: string;

  @Column({ type: 'text', nullable: true })
  signaturePath: string;

  @Column({ type: 'text', nullable: true })
  returnImage: string;

  @Column({ type: 'text', nullable: true })
  returnImagePath: string;

  @Column({ type: 'text', nullable: true })
  remark: string;

  @Column({ type: 'enum', enum: OrderStatus, default: OrderStatus.CART })
  status: OrderStatus;
  
  @Column({ type: 'boolean', default: false })
  tistatus: boolean;

  @Column({ type: 'boolean', default: false })
  remarkStatus: boolean;
  
  // delivery boy
  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  updatedBy: string;

  @Column({ type: 'uuid' })
  outletDetailId: string;

  @Column({ type: 'uuid' })
  subCategoryId: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.order, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => OutletDetail, (outletDetail) => outletDetail.order, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  outletDetail: OutletDetail[];

  @ManyToOne(() => SubCategory, (subCategory) => subCategory.order, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  subCategory: SubCategory[];
}
