import { Injectable, NotAcceptableException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { DefaultStatus } from 'src/enum';
import { Repository } from 'typeorm';
import { LoginHistory } from './entities/login-history.entity';

@Injectable()
export class LoginHistoryService {
  constructor(
    @InjectRepository(LoginHistory)
    private readonly repo: Repository<LoginHistory>,
  ) {}

  async findAll(limit: number, offset: number, accountId: string) {
    const [result, total] = await this.repo.findAndCount({
      where: { accountId },
      take: limit,
      skip: offset,
      order: { createdAt: 'DESC' },
    });
    return { result, total };
  }

  async activateLogin(id: string) {
    try {
      return this.repo
        .createQueryBuilder()
        .update()
        .set({
          status: DefaultStatus.DEACTIVE,
        })
        .where('accountId = :accountId', { accountId: id })
        .execute();
    } catch (error) {
      throw new NotAcceptableException('Try after some time!');
    }
  }
}
